TITLE   'Current through a Semiconductor' 	 		{ exa213.pde }
SELECT     errlim=1e-4    ngrid=50     		{ Initial node number }
COORDINATES
   cartesian1
VARIABLES   Ex
DEFINITIONS
   Lx=2e-4
   temp=300     J0=1.0     			{ Defer definition of Ex0 }
   q=1.60e-19     kb=1.38e-23     eps0=8.85e-12     eps=12*eps0
   ni=1e16     mue=0.13     muh=0.05
   nh0=staged(0.1*ni, ni, 10*ni)     ne0=ni^2/nh0
   De=mue*kb*temp/q     Dh=muh*kb*temp/q
   rho=dx( eps*Ex)					{ Volume charge density }
   ne=-0.5*( rho/q- ne0+ nh0)+ sqrt[ 0.25*( rho/q- ne0+ nh0)^2+ ni^2]
   nh=-0.5*( ne0- nh0- rho/q)+ sqrt[ 0.25*( ne0- nh0- rho/q)^2+ ni^2]
   Je=q*mue*ne*Ex     Jh=q*muh*nh*Ex  	{ Drift current density }
   Jde=q*De*dx( ne)     Jdh=-q*Dh*dx( nh)	{ Diffusion current d. }
   Ex0=J0/(q*ne*mue+q*nh*muh)
EQUATIONS
   q*ne*mue*Ex+ q*De*dx( ne)+ q*nh*muh*Ex- q*Dh*dx(nh)=J0
BOUNDARIES
region 'domain'
   start (-Lx)  point value(Ex)=Ex0 line to (Lx) point value(Ex)=Ex0
PLOTS
   elevation( Ex) from (-Lx) to (Lx) report( nh0) report( ne0)
   elevation( rho) from (-Lx) to (Lx)
   elevation( rho) from (0) to (Lx) report( eps*Ex0)  	{  Charge density }
   elevation( nh) from (-Lx) to (Lx) report( 2*Lx*nh0)
   elevation( ne) from (-Lx) to (Lx) report( 2*Lx*ne0)
   elevation( Jh, Jdh) from (-Lx) to (Lx)
   elevation( Je, Jde) from (-Lx) to (Lx)	
   elevation( nh*ne/ni^2) from (-Lx) to (Lx) range(0.999,1.001)	
END


